// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsLogRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsLogRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Log Request Builder.
 */
public class WorkbookFunctionsLogRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsLogRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsLog
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param number the number
     * @param base the base
     */
    public WorkbookFunctionsLogRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final com.google.gson.JsonElement number, final com.google.gson.JsonElement base) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("number", number);
        bodyParams.put("base", base);
    }

    /**
     * Creates the IWorkbookFunctionsLogRequest
     *
     * @return the IWorkbookFunctionsLogRequest instance
     */
    public IWorkbookFunctionsLogRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsLogRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsLogRequest instance
     */
    public IWorkbookFunctionsLogRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        WorkbookFunctionsLogRequest request = new WorkbookFunctionsLogRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("number")) {
            request.body.number = getParameter("number");
        }

        if (hasParameter("base")) {
            request.body.base = getParameter("base");
        }

        return request;
    }
}
