// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortRequest;
import com.microsoft.graph.requests.extensions.WorkbookTableSortRequest;
import com.microsoft.graph.models.extensions.WorkbookSortField;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortApplyRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookTableSortApplyRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortClearRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookTableSortClearRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortReapplyRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookTableSortReapplyRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Sort Request Builder.
 */
public class WorkbookTableSortRequestBuilder extends BaseRequestBuilder implements IWorkbookTableSortRequestBuilder {

    /**
     * The request builder for the WorkbookTableSort
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookTableSortRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookTableSortRequest instance
     */
    public IWorkbookTableSortRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookTableSortRequest instance
     */
    public IWorkbookTableSortRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookTableSortRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IWorkbookTableSortApplyRequestBuilder apply(final java.util.List<WorkbookSortField> fields, final Boolean matchCase, final String method) {
        return new WorkbookTableSortApplyRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.apply"), getClient(), null, fields, matchCase, method);
    }

    public IWorkbookTableSortClearRequestBuilder clear() {
        return new WorkbookTableSortClearRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clear"), getClient(), null);
    }

    public IWorkbookTableSortReapplyRequestBuilder reapply() {
        return new WorkbookTableSortReapplyRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.reapply"), getClient(), null);
    }
}

