/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.google.gson.JsonObject;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.DefaultClientConfig;
import com.microsoft.graph.core.IClientConfig;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.BaseGraphServiceClient;
import com.microsoft.graph.requests.extensions.CustomRequestBuilder;
import com.microsoft.graph.serializer.ISerializer;

public class GraphServiceClient
extends BaseGraphServiceClient
implements IGraphServiceClient {
    protected GraphServiceClient() {
    }

    @Override
    public <T> CustomRequestBuilder<T> customRequest(String url, Class<T> responseType) {
        return new CustomRequestBuilder<T>(this.getServiceRoot() + url, this, null, responseType);
    }

    @Override
    public CustomRequestBuilder<JsonObject> customRequest(String url) {
        return new CustomRequestBuilder<JsonObject>(this.getServiceRoot() + url, this, null, JsonObject.class);
    }

    public static IGraphServiceClient fromConfig(IClientConfig config) {
        GraphServiceClient client = new GraphServiceClient();
        client.setAuthenticationProvider(config.getAuthenticationProvider());
        client.setExecutors(config.getExecutors());
        client.setHttpProvider(config.getHttpProvider());
        client.setLogger(config.getLogger());
        client.setSerializer(config.getSerializer());
        client.validate();
        return client;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void checkNotNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " cannot be null");
        }
    }

    public static final class Builder2 {
        private final IAuthenticationProvider authenticationProvider;
        private ISerializer serializer;
        private IHttpProvider httpProvider;
        private IExecutors executors;
        private ILogger logger;

        Builder2(IAuthenticationProvider authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
        }

        public Builder2 serializer(ISerializer serializer) {
            GraphServiceClient.checkNotNull(serializer, "serializer");
            this.serializer = serializer;
            return this;
        }

        public Builder2 httpProvider(IHttpProvider httpProvider) {
            GraphServiceClient.checkNotNull(httpProvider, "httpProvider");
            this.httpProvider = httpProvider;
            return this;
        }

        public Builder2 executors(IExecutors executors) {
            GraphServiceClient.checkNotNull(executors, "executors");
            this.executors = executors;
            return this;
        }

        public Builder2 logger(ILogger logger) {
            GraphServiceClient.checkNotNull(logger, "logger");
            this.logger = logger;
            return this;
        }

        public IGraphServiceClient buildClient() throws ClientException {
            DefaultClientConfig config = new DefaultClientConfig(){

                @Override
                public IAuthenticationProvider getAuthenticationProvider() {
                    return Builder2.this.authenticationProvider;
                }

                @Override
                public IHttpProvider getHttpProvider() {
                    if (Builder2.this.httpProvider != null) {
                        return Builder2.this.httpProvider;
                    }
                    return super.getHttpProvider();
                }

                @Override
                public IExecutors getExecutors() {
                    if (Builder2.this.executors != null) {
                        return Builder2.this.executors;
                    }
                    return super.getExecutors();
                }

                @Override
                public ILogger getLogger() {
                    if (Builder2.this.logger != null) {
                        return Builder2.this.logger;
                    }
                    return super.getLogger();
                }

                @Override
                public ISerializer getSerializer() {
                    if (Builder2.this.serializer != null) {
                        return Builder2.this.serializer;
                    }
                    return super.getSerializer();
                }
            };
            return GraphServiceClient.fromConfig(config);
        }
    }

    public static final class Builder {
        Builder() {
        }

        public Builder2 authenticationProvider(IAuthenticationProvider authenticationProvider) {
            GraphServiceClient.checkNotNull(authenticationProvider, "authenticationProvider");
            return new Builder2(authenticationProvider);
        }
    }
}

