// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.IosDeviceType;
import com.microsoft.graph.models.extensions.VppLicensingType;
import com.microsoft.graph.models.generated.VppTokenAccountType;
import com.microsoft.graph.models.extensions.MobileApp;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Vpp App.
 */
public class IosVppApp extends MobileApp implements IJsonBackedObject {


    /**
     * The Applicable Device Type.
     * The applicable iOS Device Type.
     */
    @SerializedName(value = "applicableDeviceType", alternate = {"ApplicableDeviceType"})
    @Expose
    public IosDeviceType applicableDeviceType;

    /**
     * The App Store Url.
     * The store URL.
     */
    @SerializedName(value = "appStoreUrl", alternate = {"AppStoreUrl"})
    @Expose
    public String appStoreUrl;

    /**
     * The Bundle Id.
     * The Identity Name.
     */
    @SerializedName(value = "bundleId", alternate = {"BundleId"})
    @Expose
    public String bundleId;

    /**
     * The Licensing Type.
     * The supported License Type.
     */
    @SerializedName(value = "licensingType", alternate = {"LicensingType"})
    @Expose
    public VppLicensingType licensingType;

    /**
     * The Release Date Time.
     * The VPP application release date and time.
     */
    @SerializedName(value = "releaseDateTime", alternate = {"ReleaseDateTime"})
    @Expose
    public java.util.Calendar releaseDateTime;

    /**
     * The Total License Count.
     * The total number of VPP licenses.
     */
    @SerializedName(value = "totalLicenseCount", alternate = {"TotalLicenseCount"})
    @Expose
    public Integer totalLicenseCount;

    /**
     * The Used License Count.
     * The number of VPP licenses in use.
     */
    @SerializedName(value = "usedLicenseCount", alternate = {"UsedLicenseCount"})
    @Expose
    public Integer usedLicenseCount;

    /**
     * The Vpp Token Account Type.
     * The type of volume purchase program which the given Apple Volume Purchase Program Token is associated with. Possible values are: business, education. Possible values are: business, education.
     */
    @SerializedName(value = "vppTokenAccountType", alternate = {"VppTokenAccountType"})
    @Expose
    public VppTokenAccountType vppTokenAccountType;

    /**
     * The Vpp Token Apple Id.
     * The Apple Id associated with the given Apple Volume Purchase Program Token.
     */
    @SerializedName(value = "vppTokenAppleId", alternate = {"VppTokenAppleId"})
    @Expose
    public String vppTokenAppleId;

    /**
     * The Vpp Token Organization Name.
     * The organization associated with the Apple Volume Purchase Program Token
     */
    @SerializedName(value = "vppTokenOrganizationName", alternate = {"VppTokenOrganizationName"})
    @Expose
    public String vppTokenOrganizationName;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
