// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Configuration Request.
 */
public class AuthenticationMethodConfigurationRequest extends BaseRequest implements IAuthenticationMethodConfigurationRequest {
	
    /**
     * The request for the AuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public AuthenticationMethodConfigurationRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends AuthenticationMethodConfiguration> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the AuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodConfigurationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the AuthenticationMethodConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AuthenticationMethodConfiguration> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AuthenticationMethodConfiguration from the service
     *
     * @return the AuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AuthenticationMethodConfiguration> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethodConfiguration with a source
     *
     * @param sourceAuthenticationMethodConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AuthenticationMethodConfiguration sourceAuthenticationMethodConfiguration, final ICallback<? super AuthenticationMethodConfiguration> callback) {
        send(HttpMethod.PATCH, callback, sourceAuthenticationMethodConfiguration);
    }

    /**
     * Patches this AuthenticationMethodConfiguration with a source
     *
     * @param sourceAuthenticationMethodConfiguration the source object with updates
     * @return the updated AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodConfiguration patch(final AuthenticationMethodConfiguration sourceAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethodConfiguration);
    }

    /**
     * Creates a AuthenticationMethodConfiguration with a new object
     *
     * @param newAuthenticationMethodConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AuthenticationMethodConfiguration newAuthenticationMethodConfiguration, final ICallback<? super AuthenticationMethodConfiguration> callback) {
        send(HttpMethod.POST, callback, newAuthenticationMethodConfiguration);
    }

    /**
     * Creates a AuthenticationMethodConfiguration with a new object
     *
     * @param newAuthenticationMethodConfiguration the new object to create
     * @return the created AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodConfiguration post(final AuthenticationMethodConfiguration newAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethodConfiguration);
    }

    /**
     * Creates a AuthenticationMethodConfiguration with a new object
     *
     * @param newAuthenticationMethodConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AuthenticationMethodConfiguration newAuthenticationMethodConfiguration, final ICallback<? super AuthenticationMethodConfiguration> callback) {
        send(HttpMethod.PUT, callback, newAuthenticationMethodConfiguration);
    }

    /**
     * Creates a AuthenticationMethodConfiguration with a new object
     *
     * @param newAuthenticationMethodConfiguration the object to create/update
     * @return the created AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodConfiguration put(final AuthenticationMethodConfiguration newAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAuthenticationMethodConfigurationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AuthenticationMethodConfigurationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAuthenticationMethodConfigurationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AuthenticationMethodConfigurationRequest)this;
     }

}

