// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ChatMessage;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Chat Message Request.
 */
public interface IChatMessageRequest extends IHttpRequest {

    /**
     * Gets the ChatMessage from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ChatMessage> callback);

    /**
     * Gets the ChatMessage from the service
     *
     * @return the ChatMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChatMessage get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ChatMessage> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ChatMessage with a source
     *
     * @param sourceChatMessage the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ChatMessage sourceChatMessage, final ICallback<? super ChatMessage> callback);

    /**
     * Patches this ChatMessage with a source
     *
     * @param sourceChatMessage the source object with updates
     * @return the updated ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChatMessage patch(final ChatMessage sourceChatMessage) throws ClientException;

    /**
     * Posts a ChatMessage with a new object
     *
     * @param newChatMessage the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ChatMessage newChatMessage, final ICallback<? super ChatMessage> callback);

    /**
     * Posts a ChatMessage with a new object
     *
     * @param newChatMessage the new object to create
     * @return the created ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChatMessage post(final ChatMessage newChatMessage) throws ClientException;

    /**
     * Posts a ChatMessage with a new object
     *
     * @param newChatMessage the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ChatMessage newChatMessage, final ICallback<? super ChatMessage> callback);

    /**
     * Posts a ChatMessage with a new object
     *
     * @param newChatMessage the object to create/update
     * @return the created ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChatMessage put(final ChatMessage newChatMessage) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IChatMessageRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IChatMessageRequest expand(final String value);

}

