// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Object Partner Reference Request.
 */
public interface IDirectoryObjectPartnerReferenceRequest extends IHttpRequest {

    /**
     * Gets the DirectoryObjectPartnerReference from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Gets the DirectoryObjectPartnerReference from the service
     *
     * @return the DirectoryObjectPartnerReference from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObjectPartnerReference get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DirectoryObjectPartnerReference with a source
     *
     * @param sourceDirectoryObjectPartnerReference the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference, final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Patches this DirectoryObjectPartnerReference with a source
     *
     * @param sourceDirectoryObjectPartnerReference the source object with updates
     * @return the updated DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObjectPartnerReference patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference) throws ClientException;

    /**
     * Posts a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Posts a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the new object to create
     * @return the created DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObjectPartnerReference post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference) throws ClientException;

    /**
     * Posts a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Posts a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the object to create/update
     * @return the created DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObjectPartnerReference put(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDirectoryObjectPartnerReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDirectoryObjectPartnerReferenceRequest expand(final String value);

}

