// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IUserRevokeSignInSessionsRequest;
import com.microsoft.graph.requests.extensions.UserRevokeSignInSessionsRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Revoke Sign In Sessions Request Builder.
 */
public class UserRevokeSignInSessionsRequestBuilder extends BaseActionRequestBuilder implements IUserRevokeSignInSessionsRequestBuilder {

    /**
     * The request builder for this UserRevokeSignInSessions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserRevokeSignInSessionsRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IUserRevokeSignInSessionsRequest
     *
     * @param requestOptions the options for the request
     * @return the IUserRevokeSignInSessionsRequest instance
     */
    public IUserRevokeSignInSessionsRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IUserRevokeSignInSessionsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IUserRevokeSignInSessionsRequest instance
     */
    public IUserRevokeSignInSessionsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        UserRevokeSignInSessionsRequest request = new UserRevokeSignInSessionsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
