// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsTextRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsTextRequest;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Text Request Builder.
 */
public class WorkbookFunctionsTextRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsTextRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsText
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param value the value
     * @param formatText the formatText
     */
    public WorkbookFunctionsTextRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final com.google.gson.JsonElement value, final com.google.gson.JsonElement formatText) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("value", value);
        bodyParams.put("formatText", formatText);
    }

    /**
     * Creates the IWorkbookFunctionsTextRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsTextRequest instance
     */
    public IWorkbookFunctionsTextRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookFunctionsTextRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsTextRequest instance
     */
    public IWorkbookFunctionsTextRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookFunctionsTextRequest request = new WorkbookFunctionsTextRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("value")) {
            request.body.value = getParameter("value");
        }

        if (hasParameter("formatText")) {
            request.body.formatText = getParameter("formatText");
        }

        return request;
    }
}
