/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.AuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodRequest;
import java.util.List;

public class AuthenticationMethodRequest
extends BaseRequest
implements IAuthenticationMethodRequest {
    public AuthenticationMethodRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends AuthenticationMethod> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public AuthenticationMethodRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethod.class);
    }

    @Override
    public void get(ICallback<? super AuthenticationMethod> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public AuthenticationMethod get() throws ClientException {
        return (AuthenticationMethod)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super AuthenticationMethod> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(AuthenticationMethod sourceAuthenticationMethod, ICallback<? super AuthenticationMethod> callback) {
        this.send(HttpMethod.PATCH, callback, sourceAuthenticationMethod);
    }

    @Override
    public AuthenticationMethod patch(AuthenticationMethod sourceAuthenticationMethod) throws ClientException {
        return (AuthenticationMethod)this.send(HttpMethod.PATCH, sourceAuthenticationMethod);
    }

    @Override
    public void post(AuthenticationMethod newAuthenticationMethod, ICallback<? super AuthenticationMethod> callback) {
        this.send(HttpMethod.POST, callback, newAuthenticationMethod);
    }

    @Override
    public AuthenticationMethod post(AuthenticationMethod newAuthenticationMethod) throws ClientException {
        return (AuthenticationMethod)this.send(HttpMethod.POST, newAuthenticationMethod);
    }

    @Override
    public void put(AuthenticationMethod newAuthenticationMethod, ICallback<? super AuthenticationMethod> callback) {
        this.send(HttpMethod.PUT, callback, newAuthenticationMethod);
    }

    @Override
    public AuthenticationMethod put(AuthenticationMethod newAuthenticationMethod) throws ClientException {
        return (AuthenticationMethod)this.send(HttpMethod.PUT, newAuthenticationMethod);
    }

    @Override
    public IAuthenticationMethodRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAuthenticationMethodRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

