/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Chat;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChatCollectionPage;
import com.microsoft.graph.requests.extensions.ChatCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ChatCollectionResponse;
import com.microsoft.graph.requests.extensions.ChatRequestBuilder;
import com.microsoft.graph.requests.extensions.IChatCollectionPage;
import com.microsoft.graph.requests.extensions.IChatCollectionRequest;
import java.util.List;

public class ChatCollectionRequest
extends BaseCollectionRequest<ChatCollectionResponse, IChatCollectionPage>
implements IChatCollectionRequest {
    public ChatCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatCollectionResponse.class, IChatCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IChatCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ChatCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IChatCollectionPage get() throws ClientException {
        ChatCollectionResponse response = (ChatCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Chat newChat, ICallback<? super Chat> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ChatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChat, callback);
    }

    @Override
    public Chat post(Chat newChat) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChat);
    }

    @Override
    public IChatCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IChatCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IChatCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IChatCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IChatCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IChatCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IChatCollectionPage buildFromResponse(ChatCollectionResponse response) {
        ChatCollectionRequestBuilder builder = response.nextLink != null ? new ChatCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ChatCollectionPage page = new ChatCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

