/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceEnrollmentConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceEnrollmentConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceEnrollmentConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceEnrollmentConfigurationCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceEnrollmentConfigurationRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceEnrollmentConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceEnrollmentConfigurationCollectionRequest;
import java.util.List;

public class DeviceEnrollmentConfigurationCollectionRequest
extends BaseCollectionRequest<DeviceEnrollmentConfigurationCollectionResponse, IDeviceEnrollmentConfigurationCollectionPage>
implements IDeviceEnrollmentConfigurationCollectionRequest {
    public DeviceEnrollmentConfigurationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceEnrollmentConfigurationCollectionResponse.class, IDeviceEnrollmentConfigurationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceEnrollmentConfigurationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceEnrollmentConfigurationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionPage get() throws ClientException {
        DeviceEnrollmentConfigurationCollectionResponse response = (DeviceEnrollmentConfigurationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration, ICallback<? super DeviceEnrollmentConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceEnrollmentConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceEnrollmentConfiguration, callback);
    }

    @Override
    public DeviceEnrollmentConfiguration post(DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceEnrollmentConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceEnrollmentConfiguration);
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceEnrollmentConfigurationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceEnrollmentConfigurationCollectionPage buildFromResponse(DeviceEnrollmentConfigurationCollectionResponse response) {
        DeviceEnrollmentConfigurationCollectionRequestBuilder builder = response.nextLink != null ? new DeviceEnrollmentConfigurationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceEnrollmentConfigurationCollectionPage page = new DeviceEnrollmentConfigurationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

