/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GroupCheckGrantedPermissionsForAppCollectionPage;
import com.microsoft.graph.requests.extensions.GroupCheckGrantedPermissionsForAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupCheckGrantedPermissionsForAppCollectionResponse;
import com.microsoft.graph.requests.extensions.IGroupCheckGrantedPermissionsForAppCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupCheckGrantedPermissionsForAppCollectionRequest;
import java.util.List;

public class GroupCheckGrantedPermissionsForAppCollectionRequest
extends BaseCollectionRequest<GroupCheckGrantedPermissionsForAppCollectionResponse, IGroupCheckGrantedPermissionsForAppCollectionPage>
implements IGroupCheckGrantedPermissionsForAppCollectionRequest {
    public GroupCheckGrantedPermissionsForAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupCheckGrantedPermissionsForAppCollectionResponse.class, IGroupCheckGrantedPermissionsForAppCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super IGroupCheckGrantedPermissionsForAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupCheckGrantedPermissionsForAppCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupCheckGrantedPermissionsForAppCollectionPage post() throws ClientException {
        GroupCheckGrantedPermissionsForAppCollectionResponse response = (GroupCheckGrantedPermissionsForAppCollectionResponse)super.post(null);
        return this.buildFromResponse(response);
    }

    public IGroupCheckGrantedPermissionsForAppCollectionPage buildFromResponse(GroupCheckGrantedPermissionsForAppCollectionResponse response) {
        GroupCheckGrantedPermissionsForAppCollectionRequestBuilder builder = response.nextLink != null ? new GroupCheckGrantedPermissionsForAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupCheckGrantedPermissionsForAppCollectionPage page = new GroupCheckGrantedPermissionsForAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IGroupCheckGrantedPermissionsForAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupCheckGrantedPermissionsForAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IGroupCheckGrantedPermissionsForAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IGroupCheckGrantedPermissionsForAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IGroupCheckGrantedPermissionsForAppCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

