/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ItemActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemActivityRequest;
import java.util.List;

public class ItemActivityRequest
extends BaseRequest
implements IItemActivityRequest {
    public ItemActivityRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivity.class);
    }

    @Override
    public void get(ICallback<? super ItemActivity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ItemActivity get() throws ClientException {
        return (ItemActivity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ItemActivity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ItemActivity sourceItemActivity, ICallback<? super ItemActivity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceItemActivity);
    }

    @Override
    public ItemActivity patch(ItemActivity sourceItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.PATCH, sourceItemActivity);
    }

    @Override
    public void post(ItemActivity newItemActivity, ICallback<? super ItemActivity> callback) {
        this.send(HttpMethod.POST, callback, newItemActivity);
    }

    @Override
    public ItemActivity post(ItemActivity newItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.POST, newItemActivity);
    }

    @Override
    public void put(ItemActivity newItemActivity, ICallback<? super ItemActivity> callback) {
        this.send(HttpMethod.PUT, callback, newItemActivity);
    }

    @Override
    public ItemActivity put(ItemActivity newItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.PUT, newItemActivity);
    }

    @Override
    public IItemActivityRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

