/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.OAuth2PermissionGrant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantWithReferenceRequestBuilder;
import java.util.List;

public class OAuth2PermissionGrantCollectionReferenceRequest
extends BaseCollectionRequest<OAuth2PermissionGrantCollectionResponse, IOAuth2PermissionGrantCollectionPage>
implements IOAuth2PermissionGrantCollectionReferenceRequest {
    public OAuth2PermissionGrantCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantCollectionResponse.class, IOAuth2PermissionGrantCollectionPage.class);
    }

    @Override
    public void post(OAuth2PermissionGrant newOAuth2PermissionGrant, ICallback<? super OAuth2PermissionGrant> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/oauth2PermissionGrants/" + newOAuth2PermissionGrant.id);
        new OAuth2PermissionGrantWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOAuth2PermissionGrant, body, callback);
    }

    @Override
    public OAuth2PermissionGrant post(OAuth2PermissionGrant newOAuth2PermissionGrant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/oauth2PermissionGrants/" + newOAuth2PermissionGrant.id);
        return new OAuth2PermissionGrantWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOAuth2PermissionGrant, body);
    }

    public IOAuth2PermissionGrantCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IOAuth2PermissionGrantCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IOAuth2PermissionGrantCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

