/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OAuth2PermissionGrant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionRequest;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantRequestBuilder;
import java.util.List;

public class OAuth2PermissionGrantCollectionRequest
extends BaseCollectionRequest<OAuth2PermissionGrantCollectionResponse, IOAuth2PermissionGrantCollectionPage>
implements IOAuth2PermissionGrantCollectionRequest {
    public OAuth2PermissionGrantCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantCollectionResponse.class, IOAuth2PermissionGrantCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOAuth2PermissionGrantCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OAuth2PermissionGrantCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOAuth2PermissionGrantCollectionPage get() throws ClientException {
        OAuth2PermissionGrantCollectionResponse response = (OAuth2PermissionGrantCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OAuth2PermissionGrant newOAuth2PermissionGrant, ICallback<? super OAuth2PermissionGrant> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OAuth2PermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOAuth2PermissionGrant, callback);
    }

    @Override
    public OAuth2PermissionGrant post(OAuth2PermissionGrant newOAuth2PermissionGrant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OAuth2PermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOAuth2PermissionGrant);
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOAuth2PermissionGrantCollectionPage buildFromResponse(OAuth2PermissionGrantCollectionResponse response) {
        OAuth2PermissionGrantCollectionRequestBuilder builder = response.nextLink != null ? new OAuth2PermissionGrantCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OAuth2PermissionGrantCollectionPage page = new OAuth2PermissionGrantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

