/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OpenShiftChangeRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOpenShiftChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.IOpenShiftChangeRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestRequestBuilder;
import java.util.List;

public class OpenShiftChangeRequestCollectionRequest
extends BaseCollectionRequest<OpenShiftChangeRequestCollectionResponse, IOpenShiftChangeRequestCollectionPage>
implements IOpenShiftChangeRequestCollectionRequest {
    public OpenShiftChangeRequestCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShiftChangeRequestCollectionResponse.class, IOpenShiftChangeRequestCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOpenShiftChangeRequestCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OpenShiftChangeRequestCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOpenShiftChangeRequestCollectionPage get() throws ClientException {
        OpenShiftChangeRequestCollectionResponse response = (OpenShiftChangeRequestCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OpenShiftChangeRequest newOpenShiftChangeRequest, ICallback<? super OpenShiftChangeRequest> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OpenShiftChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOpenShiftChangeRequest, callback);
    }

    @Override
    public OpenShiftChangeRequest post(OpenShiftChangeRequest newOpenShiftChangeRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OpenShiftChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOpenShiftChangeRequest);
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOpenShiftChangeRequestCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOpenShiftChangeRequestCollectionPage buildFromResponse(OpenShiftChangeRequestCollectionResponse response) {
        OpenShiftChangeRequestCollectionRequestBuilder builder = response.nextLink != null ? new OpenShiftChangeRequestCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OpenShiftChangeRequestCollectionPage page = new OpenShiftChangeRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

