/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SettingStateDeviceSummary;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryCollectionRequest;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionResponse;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryRequestBuilder;
import java.util.List;

public class SettingStateDeviceSummaryCollectionRequest
extends BaseCollectionRequest<SettingStateDeviceSummaryCollectionResponse, ISettingStateDeviceSummaryCollectionPage>
implements ISettingStateDeviceSummaryCollectionRequest {
    public SettingStateDeviceSummaryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SettingStateDeviceSummaryCollectionResponse.class, ISettingStateDeviceSummaryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISettingStateDeviceSummaryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SettingStateDeviceSummaryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISettingStateDeviceSummaryCollectionPage get() throws ClientException {
        SettingStateDeviceSummaryCollectionResponse response = (SettingStateDeviceSummaryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SettingStateDeviceSummary newSettingStateDeviceSummary, ICallback<? super SettingStateDeviceSummary> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SettingStateDeviceSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSettingStateDeviceSummary, callback);
    }

    @Override
    public SettingStateDeviceSummary post(SettingStateDeviceSummary newSettingStateDeviceSummary) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SettingStateDeviceSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSettingStateDeviceSummary);
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISettingStateDeviceSummaryCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISettingStateDeviceSummaryCollectionPage buildFromResponse(SettingStateDeviceSummaryCollectionResponse response) {
        SettingStateDeviceSummaryCollectionRequestBuilder builder = response.nextLink != null ? new SettingStateDeviceSummaryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SettingStateDeviceSummaryCollectionPage page = new SettingStateDeviceSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

