/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyCollectionRequest;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyCollectionResponse;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.List;

public class SingleValueLegacyExtendedPropertyCollectionRequest
extends BaseCollectionRequest<SingleValueLegacyExtendedPropertyCollectionResponse, ISingleValueLegacyExtendedPropertyCollectionPage>
implements ISingleValueLegacyExtendedPropertyCollectionRequest {
    public SingleValueLegacyExtendedPropertyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SingleValueLegacyExtendedPropertyCollectionResponse.class, ISingleValueLegacyExtendedPropertyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISingleValueLegacyExtendedPropertyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SingleValueLegacyExtendedPropertyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionPage get() throws ClientException {
        SingleValueLegacyExtendedPropertyCollectionResponse response = (SingleValueLegacyExtendedPropertyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty, ICallback<? super SingleValueLegacyExtendedProperty> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SingleValueLegacyExtendedPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSingleValueLegacyExtendedProperty, callback);
    }

    @Override
    public SingleValueLegacyExtendedProperty post(SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SingleValueLegacyExtendedPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSingleValueLegacyExtendedProperty);
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISingleValueLegacyExtendedPropertyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISingleValueLegacyExtendedPropertyCollectionPage buildFromResponse(SingleValueLegacyExtendedPropertyCollectionResponse response) {
        SingleValueLegacyExtendedPropertyCollectionRequestBuilder builder = response.nextLink != null ? new SingleValueLegacyExtendedPropertyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SingleValueLegacyExtendedPropertyCollectionPage page = new SingleValueLegacyExtendedPropertyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

