/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SubscribedSku;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionPage;
import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionRequest;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionPage;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionResponse;
import com.microsoft.graph.requests.extensions.SubscribedSkuRequestBuilder;
import java.util.List;

public class SubscribedSkuCollectionRequest
extends BaseCollectionRequest<SubscribedSkuCollectionResponse, ISubscribedSkuCollectionPage>
implements ISubscribedSkuCollectionRequest {
    public SubscribedSkuCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubscribedSkuCollectionResponse.class, ISubscribedSkuCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISubscribedSkuCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SubscribedSkuCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISubscribedSkuCollectionPage get() throws ClientException {
        SubscribedSkuCollectionResponse response = (SubscribedSkuCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SubscribedSku newSubscribedSku, ICallback<? super SubscribedSku> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSubscribedSku, callback);
    }

    @Override
    public SubscribedSku post(SubscribedSku newSubscribedSku) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSubscribedSku);
    }

    @Override
    public ISubscribedSkuCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISubscribedSkuCollectionPage buildFromResponse(SubscribedSkuCollectionResponse response) {
        SubscribedSkuCollectionRequestBuilder builder = response.nextLink != null ? new SubscribedSkuCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SubscribedSkuCollectionPage page = new SubscribedSkuCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

