/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.UserActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserActivityWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class UserActivityWithReferenceRequest
extends BaseRequest
implements IUserActivityWithReferenceRequest {
    public UserActivityWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivity.class);
    }

    @Override
    public void post(UserActivity newUserActivity, IJsonBackedObject payload, ICallback<? super UserActivity> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public UserActivity post(UserActivity newUserActivity, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newUserActivity;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super UserActivity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public UserActivity get() throws ClientException {
        return (UserActivity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super UserActivity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(UserActivity sourceUserActivity, ICallback<? super UserActivity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceUserActivity);
    }

    @Override
    public UserActivity patch(UserActivity sourceUserActivity) throws ClientException {
        return (UserActivity)this.send(HttpMethod.PATCH, sourceUserActivity);
    }

    @Override
    public IUserActivityWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserActivityWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

