/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionAppLearningSummary;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLearningSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLearningSummaryCollectionRequest;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLearningSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLearningSummaryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLearningSummaryCollectionResponse;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLearningSummaryRequestBuilder;
import java.util.List;

public class WindowsInformationProtectionAppLearningSummaryCollectionRequest
extends BaseCollectionRequest<WindowsInformationProtectionAppLearningSummaryCollectionResponse, IWindowsInformationProtectionAppLearningSummaryCollectionPage>
implements IWindowsInformationProtectionAppLearningSummaryCollectionRequest {
    public WindowsInformationProtectionAppLearningSummaryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionAppLearningSummaryCollectionResponse.class, IWindowsInformationProtectionAppLearningSummaryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IWindowsInformationProtectionAppLearningSummaryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WindowsInformationProtectionAppLearningSummaryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionPage get() throws ClientException {
        WindowsInformationProtectionAppLearningSummaryCollectionResponse response = (WindowsInformationProtectionAppLearningSummaryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary, ICallback<? super WindowsInformationProtectionAppLearningSummary> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WindowsInformationProtectionAppLearningSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionAppLearningSummary, callback);
    }

    @Override
    public WindowsInformationProtectionAppLearningSummary post(WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WindowsInformationProtectionAppLearningSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionAppLearningSummary);
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLearningSummaryCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWindowsInformationProtectionAppLearningSummaryCollectionPage buildFromResponse(WindowsInformationProtectionAppLearningSummaryCollectionResponse response) {
        WindowsInformationProtectionAppLearningSummaryCollectionRequestBuilder builder = response.nextLink != null ? new WindowsInformationProtectionAppLearningSummaryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WindowsInformationProtectionAppLearningSummaryCollectionPage page = new WindowsInformationProtectionAppLearningSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

