/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkforceIntegration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkforceIntegrationCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkforceIntegrationCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkforceIntegrationCollectionPage;
import com.microsoft.graph.requests.extensions.WorkforceIntegrationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkforceIntegrationCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkforceIntegrationRequestBuilder;
import java.util.List;

public class WorkforceIntegrationCollectionRequest
extends BaseCollectionRequest<WorkforceIntegrationCollectionResponse, IWorkforceIntegrationCollectionPage>
implements IWorkforceIntegrationCollectionRequest {
    public WorkforceIntegrationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkforceIntegrationCollectionResponse.class, IWorkforceIntegrationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IWorkforceIntegrationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkforceIntegrationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkforceIntegrationCollectionPage get() throws ClientException {
        WorkforceIntegrationCollectionResponse response = (WorkforceIntegrationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkforceIntegration newWorkforceIntegration, ICallback<? super WorkforceIntegration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkforceIntegrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkforceIntegration, callback);
    }

    @Override
    public WorkforceIntegration post(WorkforceIntegration newWorkforceIntegration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkforceIntegrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkforceIntegration);
    }

    @Override
    public IWorkforceIntegrationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkforceIntegrationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkforceIntegrationCollectionPage buildFromResponse(WorkforceIntegrationCollectionResponse response) {
        WorkforceIntegrationCollectionRequestBuilder builder = response.nextLink != null ? new WorkforceIntegrationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkforceIntegrationCollectionPage page = new WorkforceIntegrationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

