// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ScopedRoleMembership;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.ScopedRoleMembershipCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Role.
 */
public class DirectoryRole extends DirectoryObject implements IJsonBackedObject {


    /**
     * The Description.
     * The description for the directory role. Read-only.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name for the directory role. Read-only.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Role Template Id.
     * The id of the directoryRoleTemplate that this role is based on. The property must be specified when activating a directory role in a tenant with a POST operation. After the directory role has been activated, the property is read only.
     */
    @SerializedName(value = "roleTemplateId", alternate = {"RoleTemplateId"})
    @Expose
	@Nullable
    public String roleTemplateId;

    /**
     * The Members.
     * Users that are members of this directory role. HTTP Methods: GET, POST, DELETE. Read-only. Nullable.
     */
	@Nullable
    public DirectoryObjectCollectionPage members;

    /**
     * The Scoped Members.
     * Members of this directory role that are scoped to administrative units. Read-only. Nullable.
     */
    @SerializedName(value = "scopedMembers", alternate = {"ScopedMembers"})
    @Expose
	@Nullable
    public ScopedRoleMembershipCollectionPage scopedMembers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("members")) {
            members = serializer.deserializeObject(json.get("members"), DirectoryObjectCollectionPage.class);
        }

        if (json.has("scopedMembers")) {
            scopedMembers = serializer.deserializeObject(json.get("scopedMembers"), ScopedRoleMembershipCollectionPage.class);
        }
    }
}
