// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Folder View.
 */
public class FolderView implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Sort By.
     * The method by which the folder should be sorted.
     */
    @SerializedName(value = "sortBy", alternate = {"SortBy"})
    @Expose
	@Nullable
    public String sortBy;

    /**
     * The Sort Order.
     * If true, indicates that items should be sorted in descending order. Otherwise, items should be sorted ascending.
     */
    @SerializedName(value = "sortOrder", alternate = {"SortOrder"})
    @Expose
	@Nullable
    public String sortOrder;

    /**
     * The View Type.
     * The type of view that should be used to represent the folder.
     */
    @SerializedName(value = "viewType", alternate = {"ViewType"})
    @Expose
	@Nullable
    public String viewType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
