// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IosHomeScreenItem;
import com.microsoft.graph.models.IosHomeScreenPage;
import com.microsoft.graph.models.IosNotificationSettings;
import com.microsoft.graph.models.AppleDeviceFeaturesConfigurationBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Device Features Configuration.
 */
public class IosDeviceFeaturesConfiguration extends AppleDeviceFeaturesConfigurationBase implements IJsonBackedObject {


    /**
     * The Asset Tag Template.
     * Asset tag information for the device, displayed on the login window and lock screen.
     */
    @SerializedName(value = "assetTagTemplate", alternate = {"AssetTagTemplate"})
    @Expose
	@Nullable
    public String assetTagTemplate;

    /**
     * The Home Screen Dock Icons.
     * A list of app and folders to appear on the Home Screen Dock. This collection can contain a maximum of 500 elements.
     */
    @SerializedName(value = "homeScreenDockIcons", alternate = {"HomeScreenDockIcons"})
    @Expose
	@Nullable
    public java.util.List<IosHomeScreenItem> homeScreenDockIcons;

    /**
     * The Home Screen Pages.
     * A list of pages on the Home Screen. This collection can contain a maximum of 500 elements.
     */
    @SerializedName(value = "homeScreenPages", alternate = {"HomeScreenPages"})
    @Expose
	@Nullable
    public java.util.List<IosHomeScreenPage> homeScreenPages;

    /**
     * The Lock Screen Footnote.
     * A footnote displayed on the login window and lock screen. Available in iOS 9.3.1 and later.
     */
    @SerializedName(value = "lockScreenFootnote", alternate = {"LockScreenFootnote"})
    @Expose
	@Nullable
    public String lockScreenFootnote;

    /**
     * The Notification Settings.
     * Notification settings for each bundle id. Applicable to devices in supervised mode only (iOS 9.3 and later). This collection can contain a maximum of 500 elements.
     */
    @SerializedName(value = "notificationSettings", alternate = {"NotificationSettings"})
    @Expose
	@Nullable
    public java.util.List<IosNotificationSettings> notificationSettings;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
