// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MessageRuleActions;
import com.microsoft.graph.models.MessageRulePredicates;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Rule.
 */
public class MessageRule extends Entity implements IJsonBackedObject {


    /**
     * The Actions.
     * Actions to be taken on a message when the corresponding conditions are fulfilled.
     */
    @SerializedName(value = "actions", alternate = {"Actions"})
    @Expose
	@Nullable
    public MessageRuleActions actions;

    /**
     * The Conditions.
     * Conditions that when fulfilled, will trigger the corresponding actions for that rule.
     */
    @SerializedName(value = "conditions", alternate = {"Conditions"})
    @Expose
	@Nullable
    public MessageRulePredicates conditions;

    /**
     * The Display Name.
     * The display name of the rule.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Exceptions.
     * Exception conditions for the rule.
     */
    @SerializedName(value = "exceptions", alternate = {"Exceptions"})
    @Expose
	@Nullable
    public MessageRulePredicates exceptions;

    /**
     * The Has Error.
     * Indicates whether the rule is in an error condition. Read-only.
     */
    @SerializedName(value = "hasError", alternate = {"HasError"})
    @Expose
	@Nullable
    public Boolean hasError;

    /**
     * The Is Enabled.
     * Indicates whether the rule is enabled to be applied to messages.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Is Read Only.
     * Indicates if the rule is read-only and cannot be modified or deleted by the rules REST API.
     */
    @SerializedName(value = "isReadOnly", alternate = {"IsReadOnly"})
    @Expose
	@Nullable
    public Boolean isReadOnly;

    /**
     * The Sequence.
     * Indicates the order in which the rule is executed, among other rules.
     */
    @SerializedName(value = "sequence", alternate = {"Sequence"})
    @Expose
	@Nullable
    public Integer sequence;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
