// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Member Settings.
 */
public class TeamMemberSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Add Remove Apps.
     * If set to true, members can add and remove apps.
     */
    @SerializedName(value = "allowAddRemoveApps", alternate = {"AllowAddRemoveApps"})
    @Expose
	@Nullable
    public Boolean allowAddRemoveApps;

    /**
     * The Allow Create Private Channels.
     * If set to true, members can add and update private channels.
     */
    @SerializedName(value = "allowCreatePrivateChannels", alternate = {"AllowCreatePrivateChannels"})
    @Expose
	@Nullable
    public Boolean allowCreatePrivateChannels;

    /**
     * The Allow Create Update Channels.
     * If set to true, members can add and update any channels.
     */
    @SerializedName(value = "allowCreateUpdateChannels", alternate = {"AllowCreateUpdateChannels"})
    @Expose
	@Nullable
    public Boolean allowCreateUpdateChannels;

    /**
     * The Allow Create Update Remove Connectors.
     * If set to true, members can add, update, and remove connectors.
     */
    @SerializedName(value = "allowCreateUpdateRemoveConnectors", alternate = {"AllowCreateUpdateRemoveConnectors"})
    @Expose
	@Nullable
    public Boolean allowCreateUpdateRemoveConnectors;

    /**
     * The Allow Create Update Remove Tabs.
     * If set to true, members can add, update, and remove tabs.
     */
    @SerializedName(value = "allowCreateUpdateRemoveTabs", alternate = {"AllowCreateUpdateRemoveTabs"})
    @Expose
	@Nullable
    public Boolean allowCreateUpdateRemoveTabs;

    /**
     * The Allow Delete Channels.
     * If set to true, members can delete channels.
     */
    @SerializedName(value = "allowDeleteChannels", alternate = {"AllowDeleteChannels"})
    @Expose
	@Nullable
    public Boolean allowDeleteChannels;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
