// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Image Parameter Set.
 */
public class WorkbookChartImageParameterSet {
    /**
     * The width.
     * 
     */
    @SerializedName(value = "width", alternate = {"Width"})
    @Expose
	@Nullable
    public Integer width;

    /**
     * The height.
     * 
     */
    @SerializedName(value = "height", alternate = {"Height"})
    @Expose
	@Nullable
    public Integer height;

    /**
     * The fitting Mode.
     * 
     */
    @SerializedName(value = "fittingMode", alternate = {"FittingMode"})
    @Expose
	@Nullable
    public String fittingMode;


    /**
     * Instiaciates a new WorkbookChartImageParameterSet
     */
    public WorkbookChartImageParameterSet() {}
    /**
     * Instiaciates a new WorkbookChartImageParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookChartImageParameterSet(@Nonnull final WorkbookChartImageParameterSetBuilder builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.fittingMode = builder.fittingMode;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookChartImageParameterSetBuilder newBuilder() {
        return new WorkbookChartImageParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookChartImageParameterSet
     */
    public static final class WorkbookChartImageParameterSetBuilder {
        /**
         * The width parameter value
         */
        @Nullable
        protected Integer width;
        /**
         * Sets the Width
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartImageParameterSetBuilder withWidth(@Nullable final Integer val) {
            this.width = val;
            return this;
        }
        /**
         * The height parameter value
         */
        @Nullable
        protected Integer height;
        /**
         * Sets the Height
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartImageParameterSetBuilder withHeight(@Nullable final Integer val) {
            this.height = val;
            return this;
        }
        /**
         * The fittingMode parameter value
         */
        @Nullable
        protected String fittingMode;
        /**
         * Sets the FittingMode
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartImageParameterSetBuilder withFittingMode(@Nullable final String val) {
            this.fittingMode = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookChartImageParameterSetBuilder
         */
        @Nullable
        protected WorkbookChartImageParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookChartImageParameterSet build() {
            return new WorkbookChartImageParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.width != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("width", width));
        }
        if(this.height != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("height", height));
        }
        if(this.fittingMode != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("fittingMode", fittingMode));
        }
        return result;
    }
}
