// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Lookup Parameter Set.
 */
public class WorkbookFunctionsLookupParameterSet {
    /**
     * The lookup Value.
     * 
     */
    @SerializedName(value = "lookupValue", alternate = {"LookupValue"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement lookupValue;

    /**
     * The lookup Vector.
     * 
     */
    @SerializedName(value = "lookupVector", alternate = {"LookupVector"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement lookupVector;

    /**
     * The result Vector.
     * 
     */
    @SerializedName(value = "resultVector", alternate = {"ResultVector"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement resultVector;


    /**
     * Instiaciates a new WorkbookFunctionsLookupParameterSet
     */
    public WorkbookFunctionsLookupParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsLookupParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsLookupParameterSet(@Nonnull final WorkbookFunctionsLookupParameterSetBuilder builder) {
        this.lookupValue = builder.lookupValue;
        this.lookupVector = builder.lookupVector;
        this.resultVector = builder.resultVector;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsLookupParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsLookupParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsLookupParameterSet
     */
    public static final class WorkbookFunctionsLookupParameterSetBuilder {
        /**
         * The lookupValue parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement lookupValue;
        /**
         * Sets the LookupValue
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsLookupParameterSetBuilder withLookupValue(@Nullable final com.google.gson.JsonElement val) {
            this.lookupValue = val;
            return this;
        }
        /**
         * The lookupVector parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement lookupVector;
        /**
         * Sets the LookupVector
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsLookupParameterSetBuilder withLookupVector(@Nullable final com.google.gson.JsonElement val) {
            this.lookupVector = val;
            return this;
        }
        /**
         * The resultVector parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement resultVector;
        /**
         * Sets the ResultVector
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsLookupParameterSetBuilder withResultVector(@Nullable final com.google.gson.JsonElement val) {
            this.resultVector = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsLookupParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsLookupParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsLookupParameterSet build() {
            return new WorkbookFunctionsLookupParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.lookupValue != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lookupValue", lookupValue));
        }
        if(this.lookupVector != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lookupVector", lookupVector));
        }
        if(this.resultVector != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("resultVector", resultVector));
        }
        return result;
    }
}
