// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Sum Ifs Parameter Set.
 */
public class WorkbookFunctionsSumIfsParameterSet {
    /**
     * The sum Range.
     * 
     */
    @SerializedName(value = "sumRange", alternate = {"SumRange"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement sumRange;

    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;


    /**
     * Instiaciates a new WorkbookFunctionsSumIfsParameterSet
     */
    public WorkbookFunctionsSumIfsParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsSumIfsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsSumIfsParameterSet(@Nonnull final WorkbookFunctionsSumIfsParameterSetBuilder builder) {
        this.sumRange = builder.sumRange;
        this.values = builder.values;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsSumIfsParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsSumIfsParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsSumIfsParameterSet
     */
    public static final class WorkbookFunctionsSumIfsParameterSetBuilder {
        /**
         * The sumRange parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement sumRange;
        /**
         * Sets the SumRange
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSumIfsParameterSetBuilder withSumRange(@Nullable final com.google.gson.JsonElement val) {
            this.sumRange = val;
            return this;
        }
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSumIfsParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsSumIfsParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsSumIfsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsSumIfsParameterSet build() {
            return new WorkbookFunctionsSumIfsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.sumRange != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sumRange", sumRange));
        }
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        return result;
    }
}
