// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Trim Parameter Set.
 */
public class WorkbookFunctionsTrimParameterSet {
    /**
     * The text.
     * 
     */
    @SerializedName(value = "text", alternate = {"Text"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement text;


    /**
     * Instiaciates a new WorkbookFunctionsTrimParameterSet
     */
    public WorkbookFunctionsTrimParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsTrimParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsTrimParameterSet(@Nonnull final WorkbookFunctionsTrimParameterSetBuilder builder) {
        this.text = builder.text;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsTrimParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsTrimParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsTrimParameterSet
     */
    public static final class WorkbookFunctionsTrimParameterSetBuilder {
        /**
         * The text parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement text;
        /**
         * Sets the Text
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTrimParameterSetBuilder withText(@Nullable final com.google.gson.JsonElement val) {
            this.text = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsTrimParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsTrimParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsTrimParameterSet build() {
            return new WorkbookFunctionsTrimParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.text != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("text", text));
        }
        return result;
    }
}
