// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookRange;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Cell Parameter Set.
 */
public class WorkbookWorksheetCellParameterSet {
    /**
     * The row.
     * 
     */
    @SerializedName(value = "row", alternate = {"Row"})
    @Expose
	@Nullable
    public Integer row;

    /**
     * The column.
     * 
     */
    @SerializedName(value = "column", alternate = {"Column"})
    @Expose
	@Nullable
    public Integer column;


    /**
     * Instiaciates a new WorkbookWorksheetCellParameterSet
     */
    public WorkbookWorksheetCellParameterSet() {}
    /**
     * Instiaciates a new WorkbookWorksheetCellParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookWorksheetCellParameterSet(@Nonnull final WorkbookWorksheetCellParameterSetBuilder builder) {
        this.row = builder.row;
        this.column = builder.column;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookWorksheetCellParameterSetBuilder newBuilder() {
        return new WorkbookWorksheetCellParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookWorksheetCellParameterSet
     */
    public static final class WorkbookWorksheetCellParameterSetBuilder {
        /**
         * The row parameter value
         */
        @Nullable
        protected Integer row;
        /**
         * Sets the Row
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookWorksheetCellParameterSetBuilder withRow(@Nullable final Integer val) {
            this.row = val;
            return this;
        }
        /**
         * The column parameter value
         */
        @Nullable
        protected Integer column;
        /**
         * Sets the Column
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookWorksheetCellParameterSetBuilder withColumn(@Nullable final Integer val) {
            this.column = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookWorksheetCellParameterSetBuilder
         */
        @Nullable
        protected WorkbookWorksheetCellParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookWorksheetCellParameterSet build() {
            return new WorkbookWorksheetCellParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.row != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("row", row));
        }
        if(this.column != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("column", column));
        }
        return result;
    }
}
