// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.requests.ChatMessageHostedContentCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageHostedContentRequestBuilder;
import com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Request.
 */
public class ChatMessageRequest extends BaseRequest<ChatMessage> {
	
    /**
     * The request for the ChatMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatMessageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessage.class);
    }

    /**
     * Gets the ChatMessage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ChatMessage from the service
     *
     * @return the ChatMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ChatMessage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ChatMessage with a source
     *
     * @param sourceChatMessage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessage> patchAsync(@Nonnull final ChatMessage sourceChatMessage) {
        return sendAsync(HttpMethod.PATCH, sourceChatMessage);
    }

    /**
     * Patches this ChatMessage with a source
     *
     * @param sourceChatMessage the source object with updates
     * @return the updated ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessage patch(@Nonnull final ChatMessage sourceChatMessage) throws ClientException {
        return send(HttpMethod.PATCH, sourceChatMessage);
    }

    /**
     * Creates a ChatMessage with a new object
     *
     * @param newChatMessage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessage> postAsync(@Nonnull final ChatMessage newChatMessage) {
        return sendAsync(HttpMethod.POST, newChatMessage);
    }

    /**
     * Creates a ChatMessage with a new object
     *
     * @param newChatMessage the new object to create
     * @return the created ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessage post(@Nonnull final ChatMessage newChatMessage) throws ClientException {
        return send(HttpMethod.POST, newChatMessage);
    }

    /**
     * Creates a ChatMessage with a new object
     *
     * @param newChatMessage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessage> putAsync(@Nonnull final ChatMessage newChatMessage) {
        return sendAsync(HttpMethod.PUT, newChatMessage);
    }

    /**
     * Creates a ChatMessage with a new object
     *
     * @param newChatMessage the object to create/update
     * @return the created ChatMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessage put(@Nonnull final ChatMessage newChatMessage) throws ClientException {
        return send(HttpMethod.PUT, newChatMessage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ChatMessageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ChatMessageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

