// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LocalizedNotificationMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Localized Notification Message Request.
 */
public class LocalizedNotificationMessageRequest extends BaseRequest<LocalizedNotificationMessage> {
	
    /**
     * The request for the LocalizedNotificationMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LocalizedNotificationMessageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LocalizedNotificationMessage.class);
    }

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LocalizedNotificationMessage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @return the LocalizedNotificationMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LocalizedNotificationMessage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LocalizedNotificationMessage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LocalizedNotificationMessage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LocalizedNotificationMessage> patchAsync(@Nonnull final LocalizedNotificationMessage sourceLocalizedNotificationMessage) {
        return sendAsync(HttpMethod.PATCH, sourceLocalizedNotificationMessage);
    }

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @return the updated LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LocalizedNotificationMessage patch(@Nonnull final LocalizedNotificationMessage sourceLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.PATCH, sourceLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LocalizedNotificationMessage> postAsync(@Nonnull final LocalizedNotificationMessage newLocalizedNotificationMessage) {
        return sendAsync(HttpMethod.POST, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LocalizedNotificationMessage post(@Nonnull final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.POST, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LocalizedNotificationMessage> putAsync(@Nonnull final LocalizedNotificationMessage newLocalizedNotificationMessage) {
        return sendAsync(HttpMethod.PUT, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LocalizedNotificationMessage put(@Nonnull final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.PUT, newLocalizedNotificationMessage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LocalizedNotificationMessageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LocalizedNotificationMessageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

