// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MicrosoftAuthenticatorAuthenticationMethod;
import com.microsoft.graph.requests.DeviceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Request Builder.
 */
public class MicrosoftAuthenticatorAuthenticationMethodRequestBuilder extends BaseRequestBuilder<MicrosoftAuthenticatorAuthenticationMethod> {

    /**
     * The request builder for the MicrosoftAuthenticatorAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the MicrosoftAuthenticatorAuthenticationMethodRequest instance
     */
    @Nonnull
    public MicrosoftAuthenticatorAuthenticationMethodRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the MicrosoftAuthenticatorAuthenticationMethodRequest instance
     */
    @Nonnull
    public MicrosoftAuthenticatorAuthenticationMethodRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Device
     *
     * @return the DeviceRequestBuilder instance
     */
    @Nonnull
    public DeviceRequestBuilder device() {
        return new DeviceRequestBuilder(getRequestUrlWithAdditionalSegment("device"), getClient(), null);
    }
}
