// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.CopyNotebookModel;
import com.microsoft.graph.models.RecentNotebook;
import com.microsoft.graph.requests.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.SectionGroupRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.NotebookCopyNotebookParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Request Builder.
 */
public class NotebookRequestBuilder extends BaseRequestBuilder<Notebook> {

    /**
     * The request builder for the Notebook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotebookRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the NotebookRequest instance
     */
    @Nonnull
    public NotebookRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the NotebookRequest instance
     */
    @Nonnull
    public NotebookRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.NotebookRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the SectionGroup collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public SectionGroupCollectionRequestBuilder sectionGroups() {
        return new SectionGroupCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sectionGroups"), getClient(), null);
    }

    /**
     * Gets a request builder for the SectionGroup item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public SectionGroupRequestBuilder sectionGroups(@Nonnull final String id) {
        return new SectionGroupRequestBuilder(getRequestUrlWithAdditionalSegment("sectionGroups") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the OnenoteSection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public OnenoteSectionCollectionRequestBuilder sections() {
        return new OnenoteSectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sections"), getClient(), null);
    }

    /**
     * Gets a request builder for the OnenoteSection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public OnenoteSectionRequestBuilder sections(@Nonnull final String id) {
        return new OnenoteSectionRequestBuilder(getRequestUrlWithAdditionalSegment("sections") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public NotebookCopyNotebookRequestBuilder copyNotebook(@Nonnull final NotebookCopyNotebookParameterSet parameters) {
        return new NotebookCopyNotebookRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyNotebook"), getClient(), null, parameters);
    }
}
