// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintConnector;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Connector Request.
 */
public class PrintConnectorRequest extends BaseRequest<PrintConnector> {
	
    /**
     * The request for the PrintConnector
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintConnectorRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnector.class);
    }

    /**
     * Gets the PrintConnector from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintConnector> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintConnector from the service
     *
     * @return the PrintConnector from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintConnector get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintConnector> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintConnector delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintConnector with a source
     *
     * @param sourcePrintConnector the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintConnector> patchAsync(@Nonnull final PrintConnector sourcePrintConnector) {
        return sendAsync(HttpMethod.PATCH, sourcePrintConnector);
    }

    /**
     * Patches this PrintConnector with a source
     *
     * @param sourcePrintConnector the source object with updates
     * @return the updated PrintConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintConnector patch(@Nonnull final PrintConnector sourcePrintConnector) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintConnector);
    }

    /**
     * Creates a PrintConnector with a new object
     *
     * @param newPrintConnector the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintConnector> postAsync(@Nonnull final PrintConnector newPrintConnector) {
        return sendAsync(HttpMethod.POST, newPrintConnector);
    }

    /**
     * Creates a PrintConnector with a new object
     *
     * @param newPrintConnector the new object to create
     * @return the created PrintConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintConnector post(@Nonnull final PrintConnector newPrintConnector) throws ClientException {
        return send(HttpMethod.POST, newPrintConnector);
    }

    /**
     * Creates a PrintConnector with a new object
     *
     * @param newPrintConnector the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintConnector> putAsync(@Nonnull final PrintConnector newPrintConnector) {
        return sendAsync(HttpMethod.PUT, newPrintConnector);
    }

    /**
     * Creates a PrintConnector with a new object
     *
     * @param newPrintConnector the object to create/update
     * @return the created PrintConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintConnector put(@Nonnull final PrintConnector newPrintConnector) throws ClientException {
        return send(HttpMethod.PUT, newPrintConnector);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintConnectorRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintConnectorRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

