// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ProfilePhoto;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Profile Photo Request.
 */
public class ProfilePhotoRequest extends BaseRequest<ProfilePhoto> {
	
    /**
     * The request for the ProfilePhoto
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ProfilePhotoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProfilePhoto.class);
    }

    /**
     * Gets the ProfilePhoto from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfilePhoto> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ProfilePhoto from the service
     *
     * @return the ProfilePhoto from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfilePhoto get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfilePhoto> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ProfilePhoto delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ProfilePhoto with a source
     *
     * @param sourceProfilePhoto the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfilePhoto> patchAsync(@Nonnull final ProfilePhoto sourceProfilePhoto) {
        return sendAsync(HttpMethod.PATCH, sourceProfilePhoto);
    }

    /**
     * Patches this ProfilePhoto with a source
     *
     * @param sourceProfilePhoto the source object with updates
     * @return the updated ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfilePhoto patch(@Nonnull final ProfilePhoto sourceProfilePhoto) throws ClientException {
        return send(HttpMethod.PATCH, sourceProfilePhoto);
    }

    /**
     * Creates a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfilePhoto> postAsync(@Nonnull final ProfilePhoto newProfilePhoto) {
        return sendAsync(HttpMethod.POST, newProfilePhoto);
    }

    /**
     * Creates a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the new object to create
     * @return the created ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfilePhoto post(@Nonnull final ProfilePhoto newProfilePhoto) throws ClientException {
        return send(HttpMethod.POST, newProfilePhoto);
    }

    /**
     * Creates a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProfilePhoto> putAsync(@Nonnull final ProfilePhoto newProfilePhoto) {
        return sendAsync(HttpMethod.PUT, newProfilePhoto);
    }

    /**
     * Creates a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the object to create/update
     * @return the created ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProfilePhoto put(@Nonnull final ProfilePhoto newProfilePhoto) throws ClientException {
        return send(HttpMethod.PUT, newProfilePhoto);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ProfilePhotoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ProfilePhotoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

