// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ThreatAssessmentRequest;
import com.microsoft.graph.requests.ThreatAssessmentResultCollectionRequestBuilder;
import com.microsoft.graph.requests.ThreatAssessmentResultRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Threat Assessment Request Request.
 */
public class ThreatAssessmentRequestRequest extends BaseRequest<ThreatAssessmentRequest> {
	
    /**
     * The request for the ThreatAssessmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ThreatAssessmentRequestRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ThreatAssessmentRequest> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ThreatAssessmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThreatAssessmentRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatAssessmentRequest.class);
    }

    /**
     * Gets the ThreatAssessmentRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ThreatAssessmentRequest from the service
     *
     * @return the ThreatAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ThreatAssessmentRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ThreatAssessmentRequest with a source
     *
     * @param sourceThreatAssessmentRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentRequest> patchAsync(@Nonnull final ThreatAssessmentRequest sourceThreatAssessmentRequest) {
        return sendAsync(HttpMethod.PATCH, sourceThreatAssessmentRequest);
    }

    /**
     * Patches this ThreatAssessmentRequest with a source
     *
     * @param sourceThreatAssessmentRequest the source object with updates
     * @return the updated ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentRequest patch(@Nonnull final ThreatAssessmentRequest sourceThreatAssessmentRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceThreatAssessmentRequest);
    }

    /**
     * Creates a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentRequest> postAsync(@Nonnull final ThreatAssessmentRequest newThreatAssessmentRequest) {
        return sendAsync(HttpMethod.POST, newThreatAssessmentRequest);
    }

    /**
     * Creates a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the new object to create
     * @return the created ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentRequest post(@Nonnull final ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException {
        return send(HttpMethod.POST, newThreatAssessmentRequest);
    }

    /**
     * Creates a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentRequest> putAsync(@Nonnull final ThreatAssessmentRequest newThreatAssessmentRequest) {
        return sendAsync(HttpMethod.PUT, newThreatAssessmentRequest);
    }

    /**
     * Creates a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the object to create/update
     * @return the created ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentRequest put(@Nonnull final ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException {
        return send(HttpMethod.PUT, newThreatAssessmentRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ThreatAssessmentRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ThreatAssessmentRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

