// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TodoTask;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.TodoTaskDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.TodoTaskDeltaCollectionRequest;
import com.microsoft.graph.requests.TodoTaskDeltaCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task Delta Collection Request Builder.
 */
public class TodoTaskDeltaCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<TodoTask, TodoTaskDeltaCollectionRequestBuilder, TodoTaskDeltaCollectionResponse, TodoTaskDeltaCollectionPage, TodoTaskDeltaCollectionRequest> {

    /**
     * The request builder for this collection of TodoTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskDeltaCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskDeltaCollectionRequestBuilder.class, TodoTaskDeltaCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TodoTaskDeltaCollectionRequest instance
     */
    @Override
    @Nonnull
    public TodoTaskDeltaCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final TodoTaskDeltaCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
