/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.groups.item.team;

import com.microsoft.graph.groups.item.team.allchannels.AllChannelsRequestBuilder;
import com.microsoft.graph.groups.item.team.archive.ArchiveRequestBuilder;
import com.microsoft.graph.groups.item.team.channels.ChannelsRequestBuilder;
import com.microsoft.graph.groups.item.team.clone.CloneRequestBuilder;
import com.microsoft.graph.groups.item.team.completemigration.CompleteMigrationRequestBuilder;
import com.microsoft.graph.groups.item.team.group.GroupRequestBuilder;
import com.microsoft.graph.groups.item.team.incomingchannels.IncomingChannelsRequestBuilder;
import com.microsoft.graph.groups.item.team.installedapps.InstalledAppsRequestBuilder;
import com.microsoft.graph.groups.item.team.members.MembersRequestBuilder;
import com.microsoft.graph.groups.item.team.operations.OperationsRequestBuilder;
import com.microsoft.graph.groups.item.team.permissiongrants.PermissionGrantsRequestBuilder;
import com.microsoft.graph.groups.item.team.photo.PhotoRequestBuilder;
import com.microsoft.graph.groups.item.team.primarychannel.PrimaryChannelRequestBuilder;
import com.microsoft.graph.groups.item.team.schedule.ScheduleRequestBuilder;
import com.microsoft.graph.groups.item.team.sendactivitynotification.SendActivityNotificationRequestBuilder;
import com.microsoft.graph.groups.item.team.tags.TagsRequestBuilder;
import com.microsoft.graph.groups.item.team.template.TemplateRequestBuilder;
import com.microsoft.graph.groups.item.team.unarchive.UnarchiveRequestBuilder;
import com.microsoft.graph.models.Team;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeamRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AllChannelsRequestBuilder allChannels() {
        return new AllChannelsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ArchiveRequestBuilder archive() {
        return new ArchiveRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ChannelsRequestBuilder channels() {
        return new ChannelsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CloneRequestBuilder clone() {
        return new CloneRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CompleteMigrationRequestBuilder completeMigration() {
        return new CompleteMigrationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GroupRequestBuilder group() {
        return new GroupRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public IncomingChannelsRequestBuilder incomingChannels() {
        return new IncomingChannelsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public InstalledAppsRequestBuilder installedApps() {
        return new InstalledAppsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MembersRequestBuilder members() {
        return new MembersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermissionGrantsRequestBuilder permissionGrants() {
        return new PermissionGrantsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PhotoRequestBuilder photo() {
        return new PhotoRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PrimaryChannelRequestBuilder primaryChannel() {
        return new PrimaryChannelRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ScheduleRequestBuilder schedule() {
        return new ScheduleRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SendActivityNotificationRequestBuilder sendActivityNotification() {
        return new SendActivityNotificationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TagsRequestBuilder tags() {
        return new TagsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TemplateRequestBuilder template() {
        return new TemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UnarchiveRequestBuilder unarchive() {
        return new UnarchiveRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public TeamRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/team{?%24expand,%24select}", pathParameters);
    }

    public TeamRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{group%2Did}/team{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public Team get() {
        return this.get(null);
    }

    @Nullable
    public Team get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Team)this.requestAdapter.send(requestInfo, errorMapping, Team::createFromDiscriminatorValue);
    }

    @Nullable
    public Team put(@Nonnull Team body) {
        return this.put(body, null);
    }

    @Nullable
    public Team put(@Nonnull Team body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPutRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Team)this.requestAdapter.send(requestInfo, errorMapping, Team::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull Team body) {
        return this.toPutRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull Team body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public TeamRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new TeamRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

