/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingsAvailabilityStatus;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AvailabilityItem
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AvailabilityItem() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AvailabilityItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AvailabilityItem();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public DateTimeTimeZone getEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("endDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("endDateTime", n -> this.setEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("serviceId", n -> this.setServiceId(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((BookingsAvailabilityStatus)n.getEnumValue(BookingsAvailabilityStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getServiceId() {
        return (String)this.backingStore.get("serviceId");
    }

    @Nullable
    public DateTimeTimeZone getStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("startDateTime");
    }

    @Nullable
    public BookingsAvailabilityStatus getStatus() {
        return (BookingsAvailabilityStatus)((Object)this.backingStore.get("status"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("endDateTime", (Parsable)this.getEndDateTime(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("serviceId", this.getServiceId());
        writer.writeObjectValue("startDateTime", (Parsable)this.getStartDateTime(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setServiceId(@Nullable String value) {
        this.backingStore.set("serviceId", (Object)value);
    }

    public void setStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStatus(@Nullable BookingsAvailabilityStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

