/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Certification
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Certification() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Certification createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Certification();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCertificationDetailsUrl() {
        return (String)this.backingStore.get("certificationDetailsUrl");
    }

    @Nullable
    public OffsetDateTime getCertificationExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("certificationExpirationDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("certificationDetailsUrl", n -> this.setCertificationDetailsUrl(n.getStringValue()));
        deserializerMap.put("certificationExpirationDateTime", n -> this.setCertificationExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("isCertifiedByMicrosoft", n -> this.setIsCertifiedByMicrosoft(n.getBooleanValue()));
        deserializerMap.put("isPublisherAttested", n -> this.setIsPublisherAttested(n.getBooleanValue()));
        deserializerMap.put("lastCertificationDateTime", n -> this.setLastCertificationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsCertifiedByMicrosoft() {
        return (Boolean)this.backingStore.get("isCertifiedByMicrosoft");
    }

    @Nullable
    public Boolean getIsPublisherAttested() {
        return (Boolean)this.backingStore.get("isPublisherAttested");
    }

    @Nullable
    public OffsetDateTime getLastCertificationDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastCertificationDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("certificationExpirationDateTime", this.getCertificationExpirationDateTime());
        writer.writeBooleanValue("isPublisherAttested", this.getIsPublisherAttested());
        writer.writeOffsetDateTimeValue("lastCertificationDateTime", this.getLastCertificationDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCertificationDetailsUrl(@Nullable String value) {
        this.backingStore.set("certificationDetailsUrl", (Object)value);
    }

    public void setCertificationExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("certificationExpirationDateTime", (Object)value);
    }

    public void setIsCertifiedByMicrosoft(@Nullable Boolean value) {
        this.backingStore.set("isCertifiedByMicrosoft", (Object)value);
    }

    public void setIsPublisherAttested(@Nullable Boolean value) {
        this.backingStore.set("isPublisherAttested", (Object)value);
    }

    public void setLastCertificationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastCertificationDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

