/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActivityBasedTimeoutPolicy;
import com.microsoft.graph.models.AdministrativeUnit;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.models.AppRoleAssignment;
import com.microsoft.graph.models.Application;
import com.microsoft.graph.models.AuthorizationPolicy;
import com.microsoft.graph.models.ClaimsMappingPolicy;
import com.microsoft.graph.models.Contract;
import com.microsoft.graph.models.CrossTenantAccessPolicy;
import com.microsoft.graph.models.Device;
import com.microsoft.graph.models.DirectoryObjectPartnerReference;
import com.microsoft.graph.models.DirectoryRole;
import com.microsoft.graph.models.DirectoryRoleTemplate;
import com.microsoft.graph.models.Endpoint;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ExtensionProperty;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.GroupSettingTemplate;
import com.microsoft.graph.models.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.models.IdentitySecurityDefaultsEnforcementPolicy;
import com.microsoft.graph.models.OrgContact;
import com.microsoft.graph.models.Organization;
import com.microsoft.graph.models.PermissionGrantPolicy;
import com.microsoft.graph.models.PolicyBase;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.models.StsPolicy;
import com.microsoft.graph.models.TenantAppManagementPolicy;
import com.microsoft.graph.models.TokenIssuancePolicy;
import com.microsoft.graph.models.TokenLifetimePolicy;
import com.microsoft.graph.models.User;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DirectoryObject
extends Entity
implements Parsable {
    @Nonnull
    public static DirectoryObject createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.activityBasedTimeoutPolicy": {
                    return new ActivityBasedTimeoutPolicy();
                }
                case "#microsoft.graph.administrativeUnit": {
                    return new AdministrativeUnit();
                }
                case "#microsoft.graph.application": {
                    return new Application();
                }
                case "#microsoft.graph.appManagementPolicy": {
                    return new AppManagementPolicy();
                }
                case "#microsoft.graph.appRoleAssignment": {
                    return new AppRoleAssignment();
                }
                case "#microsoft.graph.authorizationPolicy": {
                    return new AuthorizationPolicy();
                }
                case "#microsoft.graph.claimsMappingPolicy": {
                    return new ClaimsMappingPolicy();
                }
                case "#microsoft.graph.contract": {
                    return new Contract();
                }
                case "#microsoft.graph.crossTenantAccessPolicy": {
                    return new CrossTenantAccessPolicy();
                }
                case "#microsoft.graph.device": {
                    return new Device();
                }
                case "#microsoft.graph.directoryObjectPartnerReference": {
                    return new DirectoryObjectPartnerReference();
                }
                case "#microsoft.graph.directoryRole": {
                    return new DirectoryRole();
                }
                case "#microsoft.graph.directoryRoleTemplate": {
                    return new DirectoryRoleTemplate();
                }
                case "#microsoft.graph.endpoint": {
                    return new Endpoint();
                }
                case "#microsoft.graph.extensionProperty": {
                    return new ExtensionProperty();
                }
                case "#microsoft.graph.group": {
                    return new Group();
                }
                case "#microsoft.graph.groupSettingTemplate": {
                    return new GroupSettingTemplate();
                }
                case "#microsoft.graph.homeRealmDiscoveryPolicy": {
                    return new HomeRealmDiscoveryPolicy();
                }
                case "#microsoft.graph.identitySecurityDefaultsEnforcementPolicy": {
                    return new IdentitySecurityDefaultsEnforcementPolicy();
                }
                case "#microsoft.graph.organization": {
                    return new Organization();
                }
                case "#microsoft.graph.orgContact": {
                    return new OrgContact();
                }
                case "#microsoft.graph.permissionGrantPolicy": {
                    return new PermissionGrantPolicy();
                }
                case "#microsoft.graph.policyBase": {
                    return new PolicyBase();
                }
                case "#microsoft.graph.resourceSpecificPermissionGrant": {
                    return new ResourceSpecificPermissionGrant();
                }
                case "#microsoft.graph.servicePrincipal": {
                    return new ServicePrincipal();
                }
                case "#microsoft.graph.stsPolicy": {
                    return new StsPolicy();
                }
                case "#microsoft.graph.tenantAppManagementPolicy": {
                    return new TenantAppManagementPolicy();
                }
                case "#microsoft.graph.tokenIssuancePolicy": {
                    return new TokenIssuancePolicy();
                }
                case "#microsoft.graph.tokenLifetimePolicy": {
                    return new TokenLifetimePolicy();
                }
                case "#microsoft.graph.user": {
                    return new User();
                }
            }
        }
        return new DirectoryObject();
    }

    @Nullable
    public OffsetDateTime getDeletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("deletedDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deletedDateTime", n -> this.setDeletedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("deletedDateTime", this.getDeletedDateTime());
    }

    public void setDeletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("deletedDateTime", (Object)value);
    }
}

