/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Attachment;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FileAttachment
extends Attachment
implements Parsable {
    public FileAttachment() {
        this.setOdataType("#microsoft.graph.fileAttachment");
    }

    @Nonnull
    public static FileAttachment createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new FileAttachment();
    }

    @Nullable
    public byte[] getContentBytes() {
        return (byte[])this.backingStore.get("contentBytes");
    }

    @Nullable
    public String getContentId() {
        return (String)this.backingStore.get("contentId");
    }

    @Nullable
    public String getContentLocation() {
        return (String)this.backingStore.get("contentLocation");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("contentBytes", n -> this.setContentBytes(n.getByteArrayValue()));
        deserializerMap.put("contentId", n -> this.setContentId(n.getStringValue()));
        deserializerMap.put("contentLocation", n -> this.setContentLocation(n.getStringValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeByteArrayValue("contentBytes", this.getContentBytes());
        writer.writeStringValue("contentId", this.getContentId());
        writer.writeStringValue("contentLocation", this.getContentLocation());
    }

    public void setContentBytes(@Nullable byte[] value) {
        this.backingStore.set("contentBytes", (Object)value);
    }

    public void setContentId(@Nullable String value) {
        this.backingStore.set("contentId", (Object)value);
    }

    public void setContentLocation(@Nullable String value) {
        this.backingStore.set("contentLocation", (Object)value);
    }
}

