/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.FolderView;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Folder
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Folder() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Folder createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Folder();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getChildCount() {
        return (Integer)this.backingStore.get("childCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(3);
        deserializerMap.put("childCount", n -> this.setChildCount(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("view", n -> this.setView((FolderView)n.getObjectValue(FolderView::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public FolderView getView() {
        return (FolderView)this.backingStore.get("view");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("childCount", this.getChildCount());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("view", (Parsable)this.getView(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setChildCount(@Nullable Integer value) {
        this.backingStore.set("childCount", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setView(@Nullable FolderView value) {
        this.backingStore.set("view", (Object)value);
    }
}

