/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Location;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Reminder
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Reminder() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Reminder createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Reminder();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getChangeKey() {
        return (String)this.backingStore.get("changeKey");
    }

    @Nullable
    public DateTimeTimeZone getEventEndTime() {
        return (DateTimeTimeZone)this.backingStore.get("eventEndTime");
    }

    @Nullable
    public String getEventId() {
        return (String)this.backingStore.get("eventId");
    }

    @Nullable
    public Location getEventLocation() {
        return (Location)this.backingStore.get("eventLocation");
    }

    @Nullable
    public DateTimeTimeZone getEventStartTime() {
        return (DateTimeTimeZone)this.backingStore.get("eventStartTime");
    }

    @Nullable
    public String getEventSubject() {
        return (String)this.backingStore.get("eventSubject");
    }

    @Nullable
    public String getEventWebLink() {
        return (String)this.backingStore.get("eventWebLink");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("changeKey", n -> this.setChangeKey(n.getStringValue()));
        deserializerMap.put("eventEndTime", n -> this.setEventEndTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("eventId", n -> this.setEventId(n.getStringValue()));
        deserializerMap.put("eventLocation", n -> this.setEventLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("eventStartTime", n -> this.setEventStartTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("eventSubject", n -> this.setEventSubject(n.getStringValue()));
        deserializerMap.put("eventWebLink", n -> this.setEventWebLink(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("reminderFireTime", n -> this.setReminderFireTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public DateTimeTimeZone getReminderFireTime() {
        return (DateTimeTimeZone)this.backingStore.get("reminderFireTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("changeKey", this.getChangeKey());
        writer.writeObjectValue("eventEndTime", (Parsable)this.getEventEndTime(), new Parsable[0]);
        writer.writeStringValue("eventId", this.getEventId());
        writer.writeObjectValue("eventLocation", (Parsable)this.getEventLocation(), new Parsable[0]);
        writer.writeObjectValue("eventStartTime", (Parsable)this.getEventStartTime(), new Parsable[0]);
        writer.writeStringValue("eventSubject", this.getEventSubject());
        writer.writeStringValue("eventWebLink", this.getEventWebLink());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("reminderFireTime", (Parsable)this.getReminderFireTime(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setChangeKey(@Nullable String value) {
        this.backingStore.set("changeKey", (Object)value);
    }

    public void setEventEndTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("eventEndTime", (Object)value);
    }

    public void setEventId(@Nullable String value) {
        this.backingStore.set("eventId", (Object)value);
    }

    public void setEventLocation(@Nullable Location value) {
        this.backingStore.set("eventLocation", (Object)value);
    }

    public void setEventStartTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("eventStartTime", (Object)value);
    }

    public void setEventSubject(@Nullable String value) {
        this.backingStore.set("eventSubject", (Object)value);
    }

    public void setEventWebLink(@Nullable String value) {
        this.backingStore.set("eventWebLink", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReminderFireTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("reminderFireTime", (Object)value);
    }
}

