/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ScheduleEntityTheme;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ShiftActivity
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ShiftActivity() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ShiftActivity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ShiftActivity();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCode() {
        return (String)this.backingStore.get("code");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("code", n -> this.setCode(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("isPaid", n -> this.setIsPaid(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("theme", n -> this.setTheme((ScheduleEntityTheme)n.getEnumValue(ScheduleEntityTheme::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsPaid() {
        return (Boolean)this.backingStore.get("isPaid");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public ScheduleEntityTheme getTheme() {
        return (ScheduleEntityTheme)((Object)this.backingStore.get("theme"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("code", this.getCode());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeBooleanValue("isPaid", this.getIsPaid());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("theme", (Enum)this.getTheme());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCode(@Nullable String value) {
        this.backingStore.set("code", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setIsPaid(@Nullable Boolean value) {
        this.backingStore.set("isPaid", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setTheme(@Nullable ScheduleEntityTheme value) {
        this.backingStore.set("theme", (Object)value);
    }
}

