/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IdentityApiConnector;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserFlowApiConnectorConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserFlowApiConnectorConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserFlowApiConnectorConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserFlowApiConnectorConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(3);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("postAttributeCollection", n -> this.setPostAttributeCollection((IdentityApiConnector)n.getObjectValue(IdentityApiConnector::createFromDiscriminatorValue)));
        deserializerMap.put("postFederationSignup", n -> this.setPostFederationSignup((IdentityApiConnector)n.getObjectValue(IdentityApiConnector::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public IdentityApiConnector getPostAttributeCollection() {
        return (IdentityApiConnector)this.backingStore.get("postAttributeCollection");
    }

    @Nullable
    public IdentityApiConnector getPostFederationSignup() {
        return (IdentityApiConnector)this.backingStore.get("postFederationSignup");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("postAttributeCollection", (Parsable)this.getPostAttributeCollection(), new Parsable[0]);
        writer.writeObjectValue("postFederationSignup", (Parsable)this.getPostFederationSignup(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPostAttributeCollection(@Nullable IdentityApiConnector value) {
        this.backingStore.set("postAttributeCollection", (Object)value);
    }

    public void setPostFederationSignup(@Nullable IdentityApiConnector value) {
        this.backingStore.set("postFederationSignup", (Object)value);
    }
}

